/*==============================================================================
 Labor market series for Italy
*=============================================================================*/

clear all
set more off

cd "$insheet_files/Italy"

*===============================================================================
* I. Population Data from Istat
*===============================================================================
import excel using "Table_2.3.2   Resident population (a) at the 1st of january and average by region and geographical area - Years 1952-2010.xls", /// 
	first cellrange(A3:BH31)

reshape long y, i(nuts region_name) j(year) 

rename y POP_istat_IT
replace POP = POP/1000

label var POP_istat_IT "Population, Istat"

tempfile POP_istat_IT
save `POP_istat_IT.dta'

*===============================================================================
* II. Obstfeld and Peri data
*===============================================================================

import excel using "IT_Obstfeld_Peri_data.xlsx", first clear

tempfile precollapse
save `precollapse.dta'

* Compute values for compound regions ITH1&ITH2 
keep if nuts=="ITH1"|nuts=="ITH2"
collapse (sum) EMP UNEMP POP, by(year)
gen nuts="ITH1&ITH2" 

append using `precollapse.dta'

gen LF_OP_IT=EMP_OP_IT+UNEMP_OP_IT
label var LF_OP_IT "Labor force, Italy, Obstfeld & Peri"
label var UNEMP_OP_IT "Unemployed, Obstfeld & Peri"
label var EMP_OP_IT  "Employed, Obstfeld & Peri"
label var POP_OP_IT "Total population, Obstfeld & Peri"

merge 1:1 nuts year using `POP_istat_IT.dta', nogen

save "$dta_files/IT_labor", replace

